using System;
using System.Linq;

class Program
{
    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        long[] x = Console.ReadLine().Split().Select(long.Parse).ToArray();
        long[] h = Console.ReadLine().Split().Select(long.Parse).ToArray();

        long[] ans = new long[n];

        for (int i = 0; i < n; i++)
        {
            long best = long.MaxValue;

            // 1) Poredenje sa drugim jarbolima
            for (int j = 0; j < n; j++)
            {
                if (h[j] >= h[i]) // dovoljno visok
                {
                    long dist = Math.Abs(x[i] - x[j]);
                    if (dist < best)
                        best = dist;
                }
            }

            // 2) Poredenje sa vrhovima kanapa izmedu komšijskih jarbola
            for (int j = 0; j < n - 1; j++)
            {
                long dx = Math.Abs(x[j + 1] - x[j]);
                long peak = (h[j] + h[j + 1] + dx) / 2;

                if (peak >= h[i])
                {
                    // peak se nalazi negde izmedu jarbola j i j+1
                    // možemo aproksimirati da je "u sredini"
                    long px = (x[j] + x[j + 1]) / 2;
                    long dist = Math.Abs(px - x[i]);

                    if (dist < best)
                        best = dist;
                }
            }

            ans[i] = (best == long.MaxValue ? -1 : best);
        }

        // ispis
        for (int i = 0; i < n; i++)
            Console.WriteLine(ans[i]);
    }
}